﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using VIRP.EFR.BO;
using VIRP.EFR.DAL;

namespace VIRP_WEB.Custom.EFR
{
    public partial class AdminDoDFragment : EfrBasePage
    {
        protected override void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                ReplacePageTitle("EFR Administration > DoD Fragment Data Extract");

                // Added for 508 compliance with GridView column headers and footer
                Page.ClientScript.RegisterStartupScript(GetType(), "UpdateGridView", "UpdateGridView('" + GridViewEFRFragmentsLastExtract.ClientID + "');", true);

                SetupCommonDataSourceParameters();
            }
        }

        private void SetupCommonDataSourceParameters()
        {
            Session["ReportDoDFragment.sortColumn"] = SessionItemFactory.Create("CREATED");
            Session["ReportDoDFragment.sortOrder"] = SessionItemFactory.Create("Descending");

            ObjectDataSourceDoDFragmentLastExtract.SelectParameters["sortOrder"].DefaultValue = SessionItemValue.Get(Session["ReportDoDFragment.sortOrder"]);
            ObjectDataSourceDoDFragmentLastExtract.SelectParameters["orderBy"].DefaultValue = SessionItemValue.Get(Session["ReportDoDFragment.sortColumn"]);
            ObjectDataSourceDoDFragmentLastExtract.SelectParameters["filter"].DefaultValue = "";
        }

        public void DoDFragment_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            if (e.CommandName == "Details")
            {
                int index = Convert.ToInt32(e.CommandArgument);
                GridViewEFRFragmentsLastExtract.SelectedIndex = index;
                int id = Convert.ToInt32(GridViewEFRFragmentsLastExtract.SelectedValue);

                DoDFragmentDB manager = new DoDFragmentDB();
                VIRP.EFR.DAL.DOD_FRAGMENT_RAW_DATA file = manager.SelectByRawDataId(id);

                Response.ClearContent();
                Response.AddHeader("content-disposition", "attachment; filename=\"" + file.ORIGINAL_NAME + "\"");
                Response.ContentType = "application/vnd.ms-excel";
                Response.BinaryWrite((byte[])file.FILE_DATA.ToArray());
            }
        }
    }
}